/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.client;

import com.finallion.graveyard.blockentities.render.GravestoneBlockEntityRenderer;
import com.finallion.graveyard.entites.renders.AcolyteRender;
import com.finallion.graveyard.entites.renders.GhoulRenderer;
import com.finallion.graveyard.entites.renders.ReaperRenderer;
import com.finallion.graveyard.entites.renders.SkeletonCreeperRender;
import com.finallion.graveyard.init.TGBlocks;
import com.finallion.graveyard.init.TGEntities;
import com.finallion.graveyard.init.TGTileEntities;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.BlockItem;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class TheGraveyardClient {
    private static final RenderType CUTOUT_MIPPED = RenderType.func_228641_d_();

    public TheGraveyardClient() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::clientInit);
        modEventBus.addListener(this::onBlockColorsInit);
        modEventBus.addListener(this::onItemColorsInit);
    }

    @SubscribeEvent
    public void onBlockColorsInit(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        blockColors.func_186722_a((unknown, lightReader, pos, unknown2) -> lightReader != null && pos != null ? BiomeColors.func_228358_a_((IBlockDisplayReader)lightReader, (BlockPos)pos) : GrassColors.func_77480_a((double)0.5, (double)1.0), new Block[]{TGBlocks.TG_GRASS_BLOCK});
    }

    @SubscribeEvent
    public void onItemColorsInit(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        IItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            BlockState state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
            return blockColors.func_228054_a_(state, null, null, tintIndex);
        };
        itemColors.func_199877_a(itemBlockColourHandler, new IItemProvider[]{TGBlocks.TG_GRASS_BLOCK});
    }

    @SubscribeEvent
    public void clientInit(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)TGBlocks.DARK_IRON_BARS, (RenderType)CUTOUT_MIPPED);
        RenderTypeLookup.setRenderLayer((Block)TGBlocks.TG_GRASS_BLOCK, (RenderType)CUTOUT_MIPPED);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TGTileEntities.GRAVESTONE_BLOCK_ENTITY.get()), GravestoneBlockEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TGEntities.SKELETON_CREEPER, SkeletonCreeperRender::new);
        RenderingRegistry.registerEntityRenderingHandler(TGEntities.ACOLYTE, AcolyteRender::new);
        RenderingRegistry.registerEntityRenderingHandler(TGEntities.GHOUL, GhoulRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TGEntities.REAPER, ReaperRenderer::new);
    }
}

